<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Sample;

class SampleController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth')->except(['publicView']);
    }

    public function index()
    {
        $samples = Sample::latest()->paginate(20);
        return view('samples.index', compact('samples'));
    }

    public function create()
    {
        return view('samples.create');
    }

    public function store(Request $request)
    {
        $data = $request->validate([
            'date' => 'nullable|date',
            'product_name' => 'required|string|max:255',
            'purity' => 'nullable|string|max:100',
            'molecular_weight' => 'nullable|string|max:100',
            'company_name' => 'nullable|string|max:255',
            'purpose' => 'nullable|string',
            'remarks' => 'nullable|string',
        ]);

        $sample = Sample::create($data);

        return redirect()->route('samples.label', $sample->id)->with('ok', 'Sample saved.');
    }

    public function label(Sample $sample)
    {
        return view('samples.label', compact('sample'));
    }

    public function publicView($id)
    {
        $sample = Sample::findOrFail($id);
        return view('samples.public_view', compact('sample'));
    }

    public function destroy(Sample $sample)
    {
        $sample->delete();
        return redirect()->route('samples.index')->with('ok', 'Deleted.');
    }
}
