<?php

use App\Http\Controllers\ProfileController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\SampleController;
use App\Models\User;
use App\Models\Sample;
Route::get('/', function () {
    return view('welcome');
});

Route::get('/dashboard', function () {
   
   
    $totalUsers = User::count();
    $totalSamples = Sample::count();
    $totalQRCodes = Sample::count(); // QR har sample ka hota hai

    return view('dashboard', compact(
        'totalUsers',
        'totalSamples',
        'totalQRCodes',
        
    ));
})->middleware(['auth', 'verified'])->name('dashboard');

Route::middleware('auth')->group(function () {
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
     Route::get('/samples', [SampleController::class, 'index'])->name('samples.index');
    Route::get('/samples/create', [SampleController::class, 'create'])->name('samples.create');
    Route::post('/samples', [SampleController::class, 'store'])->name('samples.store');
    Route::get('/samples/{sample}/label', [SampleController::class, 'label'])->name('samples.label');
    Route::delete('/samples/{sample}', [SampleController::class, 'destroy'])->name('samples.destroy');
    Route::get('/samples/{id}/edit', [SampleController::class, 'edit'])->name('samples.edit');
Route::put('/samples/{id}', [SampleController::class, 'update'])->name('samples.update');
});

require __DIR__.'/auth.php';





// public QR view
Route::get('/samples/{id}/view', [SampleController::class, 'publicView'])->name('samples.public_view');
