<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Sample extends Model
{
    protected $fillable = [
        'date','product_name','purity','molecular_weight','company_name','purpose','remarks','sample_code'
    ];

    protected static function booted()
    {
        static::creating(function ($sample) {
            if (empty($sample->sample_code)) {
                $date = now()->format('Ymd');
                $countToday = static::whereDate('created_at', now()->toDateString())->count() + 1;
                $sample->sample_code = sprintf('S-%s-%04d', $date, $countToday);
            }
        });

        static::created(function($s){
            \App\Models\ActivityLog::log(auth()->id() ?? null, request()->ip(), 'create_sample', "Created sample", Sample::class, $s->id);
        });

        static::updated(function($s){
            \App\Models\ActivityLog::log(auth()->id() ?? null, request()->ip(), 'update_sample', Sample::class, $s->id);
        });

        static::deleted(function($s){
            \App\Models\ActivityLog::log(auth()->id() ?? null, request()->ip(), 'delete_sample', Sample::class, $s->id);
        });
    }
}
